/* ----------------------------------------------------------		
 *    	GUI FOR N96 LCD
 *-----------------------------------------------------------
 *	 	Name:  GUI.CPP
 *	 	Purpose: Create Graphical User Interface for N96 LCD
 *   	Version = beta 0.6
 *   	Supported Objects = Alert & List
 *   	New Version @ digitronic.ir
 *-----------------------------------------------------------
 *		Programmer = Ramin Jafarpour
 *  	ramin.jafarpour@hotmail.com 
 * 		WWW.ECA.ir
 *----------------------------------------------------------- */  

#include <string.h>
#include "gui.h"


namespace GUI {


	// Command Class for gui touchable objects
	class Command{

		public :
			char 	 *Text;
  			char X,Y,Len;
			Command(char *txt,int x,int y,int len){
				Text = new char[10];
	 			strcpy(Text,txt);
				X = x;
				Y = y;	
				Len = len;			
			}
			/*
			Command(){
				Text = new char[10];
			}
			*/			
	};

	// Alert Class
	class Alert  {

		public:

		Command *cmd1,*cmd2;		 
		enum AlertType	{	
	 		OK = 1,
			YESNO = 2,
			RETRY = 3
	 	};
		bool haveImage;
		AlertType Type; 
		char     *Title;
		char 	 *Text;
  		const unsigned short *Image ;

  		Alert(char *ttl,char *txt, const unsigned short *img,AlertType type) {

			Title = new char[30];
			Text = new char[60];
	 		strcpy(Title,ttl);
			strcpy(Text,txt);
			Image = img; 
			Type = type;
			haveImage = 1;			
		}

  		Alert(char *ttl,char *txt,AlertType type) {
			Title = new char[30];
			Text = new char[60];
	 		strcpy(Title,ttl);
			strcpy(Text,txt);
			Image = 0; 
			Type = type;
			haveImage = 0; 
		}

		Alert(){
			Title = new char[30];
			Text = new char[60];
			haveImage = 0; 
		}

		void SetImage(const unsigned short *img){
			Image = img; 
			haveImage = 1;		
		}
	};

	// List Class 
	class List{

		public:

		Command *cmd[20];
		const unsigned short *Image[20] ;
		enum ListType	{	
	 		Exclusive = 1,
			Multiple = 2,
			Implicit = 3
	 	};

		ListType Type; 
		int ListNumber;
		char     *Title;
		char 	 *Text[20];	
		
		void Add(char *txt){
			Text[ListNumber] = new char[30];		
			strcpy(Text[ListNumber],txt);
			ListNumber++;
		}

		void Add(char *txt,const unsigned short *Image_icon)	{
			Text[ListNumber] = new char[30];		
			strcpy(Text[ListNumber],txt);
			Image[ListNumber] = Image_icon; 
			ListNumber++;

		}
			
		List(char *ttl,char *txt[],ListType type) {
				Title = new char[30];
				for (ListNumber=0;ListNumber<sizeof(txt);ListNumber++) {
					Text[ListNumber] = new char[30];
					strcpy(Text[ListNumber],txt[ListNumber]);
				}
				strcpy(Title,ttl);
		}

		List(char *ttl,ListType type){
			Title = new char[30];
			strcpy(Title,ttl);
			ListNumber = 0;	
		}

	};


	/// Display Class for show All Objects in N96 Display

	class Display {

		Command *command[20];
		int cmdcount;
		int selected_cmd;
		int i;

		public:

			Display() {
				tftlcd_init();
			}

			void Show (Alert alert) {
				tftlcd_clear();
				tftlcd_gotoxy(15-strlen(alert.Title)/2,0);
				tftlcd_puts(alert.Title,BLACK,WHITE,0);

				if (alert.haveImage) {
					tftlcd_write_pic(70+(100-(int)*alert.Image)/2,40,alert.Image);
				}
  				tftlcd_gotoxy(5,10);
				tftlcd_puts(alert.Text,BLACK,WHITE,0);

				if (alert.Type == Alert::OK) {
					tftlcd_write_pic(79,247,button_image);
					//tftlcd_draw_rectangle(79,247,159,279,0,RED);
					tftlcd_gotoxy(14,16);
					tftlcd_puts("OK",BLACK,WHITE,1);
					command[0] = new Command("OK",79,247,80);
					alert.cmd1 = command[0];
					cmdcount = 1;
				}
				else if  (alert.Type == Alert::YESNO) {
					tftlcd_write_pic(29,247,button_image);
					//tftlcd_draw_rectangle(29,247,80,32,0,RED);
					tftlcd_gotoxy(8,16);
					tftlcd_puts("NO",BLACK,WHITE,1);
					tftlcd_write_pic(129,247,button_image);
					//tftlcd_draw_rectangle(129,247,80,32,0,RED);
					tftlcd_gotoxy(20,16);
					tftlcd_puts("YES",BLACK,WHITE,1);
					command[0] = new Command("NO",29,247,80);
					alert.cmd1 = command[0];
					command[1] = new Command("YES",129,247,80);
					alert.cmd2 = command[1];
					cmdcount = 2;			
				}

				else if (alert.Type == Alert::RETRY) {
					tftlcd_write_pic(29,247,button_image);
					//tftlcd_draw_rectangle(29,247,80,32,0,RED);
					tftlcd_gotoxy(6,16);
					tftlcd_puts("ABORT",BLACK,WHITE,1);
					tftlcd_write_pic(129,247,button_image);
					//tftlcd_draw_rectangle(129,247,80,32,0,RED);
					tftlcd_gotoxy(19,16);
					tftlcd_puts("RETRY",BLACK,WHITE,1);	
					command[0] = new Command("ABORT",29,247,80);
					alert.cmd1 = command[0];
					command[1] = new Command("RETRY",129,247,80);
					alert.cmd2 = command[1];
					cmdcount = 2;		
				} 
			}

			void Show (List list) {
				int i;

				tftlcd_fill(WHITE);
				tftlcd_draw_rectangle(0,0,239,15,1,BLACK);
				tftlcd_gotoxy(15-strlen(list.Title)/2,0);
				tftlcd_puts(list.Title,WHITE,BLACK,0);
				for (i=0;i<list.ListNumber;i++) {
					if (list.Image[i] != 0) tftlcd_write_pic(5,27+i*32,list.Image[i]);
					tftlcd_gotoxy(4,i*2+2);
					tftlcd_puts(list.Text[i],BLACK,WHITE,0);
					command[i] = new Command(list.Text[i],0,24+i*32,240);
				}
				cmdcount = i;
			}

			void Show (const unsigned short *Image) {

				tftlcd_init_hispeed(0,Image[0]-1,0,Image[1]-1);
				TFTLCD_RS_HIGH;
				for (int i = 2 ;i<Image[0]*Image[1] ;i++) {
				 	TFTLCD_CS_LOW;
					TFTLCD_WR_LOW;
					TFTLCD_DATAPORT_CLEAR;
					_TFTLCD_DATAPORT_SODR_ = (Image[i] << TFTLCD_DATAPORT_OFFSET);
					TFTLCD_WR_HIGH;
					TFTLCD_CS_HIGH;	
				}
				TFTLCD_RS_LOW;
			}
			
			// cheak Commands to touch Event
			char *cheak(){
				int x1,y1;
				char buffer[20];

				if(touch(&x1,&y1)==1) {
					x1 = 240-(x1*219/x_range);
					y1 = 320-(y1*320/y_range);

					sprintf(buffer,"X=%u   ",x1);	     
					tftlcd_gotoxy(24,18);
					tftlcd_puts(buffer,RED,WHITE,0);
					sprintf(buffer,"Y=%u   ",y1);	
					tftlcd_gotoxy(24,19);
					tftlcd_puts(buffer,RED,WHITE,0);

					 for (i=0;i<cmdcount;i++) {
						if (x1>command[i]->X && x1<command[i]->X+command[i]->Len && y1>command[i]->Y && y1<command[i]->Y+32 ) {
							tftlcd_draw_circle(command[i]->X+16,command[i]->Y+16,8,1,RED);	
							return command[i]->Text;
						}
						else 
							tftlcd_draw_circle(command[i]->X+16,command[i]->Y+16,8,1,WHITE);
					}
				}else 	tftlcd_draw_rectangle(160,280,239,319,1,WHITE); //clear X , Y
				return 0;
			}					
	};
}
